/*------------------------------------------------------------------------------*
 * File Name: ProjectProtections.c				 													*
 * Creation: Army 08/17/2009																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
//Include your own header files here.
#include "ProjectProtections.h"
////////////////////////////////////////////////////////////////////////////////////
#define MIN_GAP                         10
///////////////////
////////////////////////////////////////////////////////////////////////////////////

// Start your functions here.	
void ProtectionsListView::InitControl(WndContainer& dlg)
{
	Init(IDC_AUDIT_LOG_MESSAGE, dlg);
			
	SetSelection(flexSelectionByRow);
	SetAllowSelection(true);
	SetEditable();
	SetTreeView(false);

	setupColHeader();
	updateAuditList();
}
	
bool ProtectionsListView::setupColHeader()
{
	vector<string> 		vsColHeaders;
	vsColHeaders.Add( _L("User Name") );
	vsColHeaders.Add( _L("Date") );		
	vsColHeaders.Add( _L("Action") );		

	// set the size of rows and columns		
	SetupRowsCols(1, 0,  1, vsColHeaders.GetSize());
	
	m_flx.ExplorerBar = flexExSortShow;	
	
	// setup column header
	for( int ii = 0; ii < vsColHeaders.GetSize(); ii++ )
	{
		SetColHeading(ii, vsColHeaders[ii]);
	}
	return true;
}
	
void ProtectionsListView::updateAuditList()
{	
	string strLogMsg;
	Project proj;
	if( !proj.GetProjAuditLogInfo(strLogMsg) )
	{
		return;
	}	

	vector<string> vsLogMsgs;
	int nNumber = strLogMsg.Count('|');
	vsLogMsgs.SetSize(nNumber+1);
	int nRet = strLogMsg.GetTokens(vsLogMsgs, '|');
	
	vector<string> vsNames, vsDates, vsActions;
	for(int ii=0; ii<vsLogMsgs.GetSize(); ii+=3)
	{
		vsNames.Add( vsLogMsgs[ii] );
		vsDates.Add( vsLogMsgs[ii+1] );
		vsActions.Add( vsLogMsgs[ii+2] );
	}
	
	int nSelRow = GetSelectedRow();
	SetColValues(LIST_USER_NAME_COL, vsNames, 0, true);
	SetColValues(LIST_DATE_COL, vsDates, 0, true);		
	SetColValues(LIST_ACTION_COL, vsActions, 0, true);
	
	SelRow(nSelRow);
	ResizeCols();
}	

//////////////////////////////////////////////////////////////////////	
///////////////////ProjectProtectionsDlg class Begin//////////////////			
//////////////////////////////////////////////////////////////////////			
int ProjectProtectionsDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	int nRet = DoModal(hWndParent, 0);
	return nRet;
}

BOOL ProjectProtectionsDlg::OnInitDialog()
{
	ResizeDialog::OnInitDialog();
	
	m_plv.InitControl(*this);
	return true;
}
	
BOOL ProjectProtectionsDlg::OnReady()
{
	SetInitReady();	
	return true;
}	
	
BOOL ProjectProtectionsDlg::OnDestroy()
{
	return true;
}
	
BOOL ProjectProtectionsDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return false;
	MoveControlsHelper	_temp(this);	
	
	int nGap = MIN_GAP; 

	RECT r1;
	GetClientRect(&r1);

	Control ctrl = GetItem(IDOK);
	RECT rr, rRef;
	GetClientRect(ctrl, rr);
	int nWidth = RECT_WIDTH(rr), nHeight = RECT_HEIGHT(rr);
	rr.right = r1.right - nGap;
	rr.left = rr.right - nWidth;
	rr.bottom = r1.bottom;
	rr.top = rr.bottom - nHeight;
	MoveControl(ctrl, rr);		
	
	Control ctrlTree = GetItem(IDC_AUDIT_LOG_MESSAGE);
	RECT 	rrTree;
	GetClientRect(ctrlTree, rrTree);
	rrTree.left = r1.left + nGap;
	rrTree.top = r1.top + nGap;
	rrTree.right = r1.right - nGap;
	rrTree.bottom = r1.bottom - nGap - nHeight;		
	MoveControl(ctrlTree, rrTree);	
	
	return true;
}

BOOL ProjectProtectionsDlg::OnClickOK()
{
	return TRUE;
}
	

